package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Planner;
import odata.msgraph.client.beta.entity.collection.request.PlannerBucketCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PlannerPlanCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PlannerRosterCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PlannerTaskCollectionRequest;

@JsonIgnoreType
public class PlannerRequest extends EntityRequest<Planner> {

    public PlannerRequest(ContextPath contextPath, Optional<Object> value) {
        super(Planner.class, contextPath, value, false);
    }

    public PlannerBucketRequest buckets(String id) {
        return new PlannerBucketRequest(contextPath.addSegment("buckets").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PlannerBucketCollectionRequest buckets() {
        return new PlannerBucketCollectionRequest(
                        contextPath.addSegment("buckets"), Optional.empty());
    }

    public PlannerPlanRequest plans(String id) {
        return new PlannerPlanRequest(contextPath.addSegment("plans").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PlannerPlanCollectionRequest plans() {
        return new PlannerPlanCollectionRequest(
                        contextPath.addSegment("plans"), Optional.empty());
    }

    public PlannerRosterRequest rosters(String id) {
        return new PlannerRosterRequest(contextPath.addSegment("rosters").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PlannerRosterCollectionRequest rosters() {
        return new PlannerRosterCollectionRequest(
                        contextPath.addSegment("rosters"), Optional.empty());
    }

    public PlannerTaskRequest tasks(String id) {
        return new PlannerTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PlannerTaskCollectionRequest tasks() {
        return new PlannerTaskCollectionRequest(
                        contextPath.addSegment("tasks"), Optional.empty());
    }

}
