package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PlannerPlan;
import odata.msgraph.client.beta.entity.collection.request.PlannerBucketCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PlannerTaskCollectionRequest;

@JsonIgnoreType
public class PlannerPlanRequest extends EntityRequest<PlannerPlan> {

    public PlannerPlanRequest(ContextPath contextPath, Optional<Object> value) {
        super(PlannerPlan.class, contextPath, value, false);
    }

    public PlannerBucketRequest buckets(String id) {
        return new PlannerBucketRequest(contextPath.addSegment("buckets").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PlannerBucketCollectionRequest buckets() {
        return new PlannerBucketCollectionRequest(
                        contextPath.addSegment("buckets"), Optional.empty());
    }

    public PlannerPlanDetailsRequest details() {
        return new PlannerPlanDetailsRequest(contextPath.addSegment("details"), Optional.empty());
    }

    public PlannerTaskRequest tasks(String id) {
        return new PlannerTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PlannerTaskCollectionRequest tasks() {
        return new PlannerTaskCollectionRequest(
                        contextPath.addSegment("tasks"), Optional.empty());
    }

}
