package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PlannerGroup;
import odata.msgraph.client.beta.entity.collection.request.PlannerPlanCollectionRequest;

@JsonIgnoreType
public class PlannerGroupRequest extends EntityRequest<PlannerGroup> {

    public PlannerGroupRequest(ContextPath contextPath, Optional<Object> value) {
        super(PlannerGroup.class, contextPath, value, false);
    }

    public PlannerPlanRequest plans(String id) {
        return new PlannerPlanRequest(contextPath.addSegment("plans").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PlannerPlanCollectionRequest plans() {
        return new PlannerPlanCollectionRequest(
                        contextPath.addSegment("plans"), Optional.empty());
    }

}
