package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DriveRecipient;
import odata.msgraph.client.beta.entity.Permission;

@JsonIgnoreType
public class PermissionRequest extends EntityRequest<Permission> {

    public PermissionRequest(ContextPath contextPath, Optional<Object> value) {
        super(Permission.class, contextPath, value, false);
    }

    @Action(name = "grant")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Permission> grant(List<String> roles, List<DriveRecipient> recipients) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("roles", "Collection(Edm.String)", Checks.checkIsAscii(roles))
            .put("recipients", "Collection(microsoft.graph.driveRecipient)", recipients)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.grant"), Permission.class, _parameters);
    }

    @Action(name = "revokeGrants")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Permission> revokeGrants(List<DriveRecipient> grantees) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("grantees", "Collection(microsoft.graph.driveRecipient)", grantees)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Permission>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.revokeGrants"), Permission.class, _parameters);
    }

}
