package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PermissionGrantPolicy;
import odata.msgraph.client.beta.entity.collection.request.PermissionGrantConditionSetCollectionRequest;

@JsonIgnoreType
public class PermissionGrantPolicyRequest extends EntityRequest<PermissionGrantPolicy> {

    public PermissionGrantPolicyRequest(ContextPath contextPath, Optional<Object> value) {
        super(PermissionGrantPolicy.class, contextPath, value, false);
    }

    public PermissionGrantConditionSetRequest excludes(String id) {
        return new PermissionGrantConditionSetRequest(contextPath.addSegment("excludes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PermissionGrantConditionSetCollectionRequest excludes() {
        return new PermissionGrantConditionSetCollectionRequest(
                        contextPath.addSegment("excludes"), Optional.empty());
    }

    public PermissionGrantConditionSetRequest includes(String id) {
        return new PermissionGrantConditionSetRequest(contextPath.addSegment("includes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PermissionGrantConditionSetCollectionRequest includes() {
        return new PermissionGrantConditionSetCollectionRequest(
                        contextPath.addSegment("includes"), Optional.empty());
    }

}
