package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Prompt;
import odata.msgraph.client.beta.entity.MuteParticipantOperation;
import odata.msgraph.client.beta.entity.Participant;
import odata.msgraph.client.beta.entity.StartHoldMusicOperation;
import odata.msgraph.client.beta.entity.StopHoldMusicOperation;

@JsonIgnoreType
public class ParticipantRequest extends EntityRequest<Participant> {

    public ParticipantRequest(ContextPath contextPath, Optional<Object> value) {
        super(Participant.class, contextPath, value, false);
    }

    @Action(name = "mute")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<MuteParticipantOperation> mute(String clientContext) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<MuteParticipantOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.mute"), MuteParticipantOperation.class, _parameters);
    }

    @Action(name = "startHoldMusic")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<StartHoldMusicOperation> startHoldMusic(Prompt customPrompt, String clientContext) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("customPrompt", "microsoft.graph.prompt", customPrompt)
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<StartHoldMusicOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.startHoldMusic"), StartHoldMusicOperation.class, _parameters);
    }

    @Action(name = "stopHoldMusic")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<StopHoldMusicOperation> stopHoldMusic(String clientContext) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("clientContext", "Edm.String", Checks.checkIsAscii(clientContext))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<StopHoldMusicOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.stopHoldMusic"), StopHoldMusicOperation.class, _parameters);
    }

}
