package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OutlookTaskFolder;
import odata.msgraph.client.beta.entity.collection.request.MultiValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OutlookTaskCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SingleValueLegacyExtendedPropertyCollectionRequest;

@JsonIgnoreType
public class OutlookTaskFolderRequest extends EntityRequest<OutlookTaskFolder> {

    public OutlookTaskFolderRequest(ContextPath contextPath, Optional<Object> value) {
        super(OutlookTaskFolder.class, contextPath, value, false);
    }

    public MultiValueLegacyExtendedPropertyRequest multiValueExtendedProperties(String id) {
        return new MultiValueLegacyExtendedPropertyRequest(contextPath.addSegment("multiValueExtendedProperties").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MultiValueLegacyExtendedPropertyCollectionRequest multiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("multiValueExtendedProperties"), Optional.empty());
    }

    public SingleValueLegacyExtendedPropertyRequest singleValueExtendedProperties(String id) {
        return new SingleValueLegacyExtendedPropertyRequest(contextPath.addSegment("singleValueExtendedProperties").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SingleValueLegacyExtendedPropertyCollectionRequest singleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("singleValueExtendedProperties"), Optional.empty());
    }

    public OutlookTaskRequest tasks(String id) {
        return new OutlookTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OutlookTaskCollectionRequest tasks() {
        return new OutlookTaskCollectionRequest(
                        contextPath.addSegment("tasks"), Optional.empty());
    }

}
