package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OutboundSharedUserProfile;
import odata.msgraph.client.beta.entity.collection.request.TenantReferenceCollectionRequest;

@JsonIgnoreType
public class OutboundSharedUserProfileRequest extends EntityRequest<OutboundSharedUserProfile> {

    public OutboundSharedUserProfileRequest(ContextPath contextPath, Optional<Object> value) {
        super(OutboundSharedUserProfile.class, contextPath, value, false);
    }

    public TenantReferenceRequest tenants(String id) {
        return new TenantReferenceRequest(contextPath.addSegment("tenants").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TenantReferenceCollectionRequest tenants() {
        return new TenantReferenceCollectionRequest(
                        contextPath.addSegment("tenants"), Optional.empty());
    }

}
