package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.entity.Organization;
import odata.msgraph.client.beta.entity.collection.request.CertificateBasedAuthConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;

@JsonIgnoreType
public class OrganizationRequest extends EntityRequest<Organization> {

    public OrganizationRequest(ContextPath contextPath, Optional<Object> value) {
        super(Organization.class, contextPath, value, false);
    }

    public OrganizationalBrandingRequest branding() {
        return new OrganizationalBrandingRequest(contextPath.addSegment("branding"), Optional.empty());
    }

    public CertificateBasedAuthConfigurationRequest certificateBasedAuthConfiguration(String id) {
        return new CertificateBasedAuthConfigurationRequest(contextPath.addSegment("certificateBasedAuthConfiguration").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CertificateBasedAuthConfigurationCollectionRequest certificateBasedAuthConfiguration() {
        return new CertificateBasedAuthConfigurationCollectionRequest(
                        contextPath.addSegment("certificateBasedAuthConfiguration"), Optional.empty());
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"), Optional.empty());
    }

    public OrganizationSettingsRequest settings() {
        return new OrganizationSettingsRequest(contextPath.addSegment("settings"), Optional.empty());
    }

    @Action(name = "activateService")
    @JsonIgnore
    public ActionRequestNoReturn activateService(String service, UUID servicePlanId, UUID skuId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("service", "Edm.String", Checks.checkIsAscii(service))
            .put("servicePlanId", "Edm.Guid", servicePlanId)
            .put("skuId", "Edm.Guid", skuId)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.activateService"), _parameters);
    }

    @Action(name = "setMobileDeviceManagementAuthority")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Integer> setMobileDeviceManagementAuthority() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollection<Integer>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setMobileDeviceManagementAuthority"), Integer.class, _parameters);
    }

}
