package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OnlineMeeting;
import odata.msgraph.client.beta.entity.collection.request.MeetingAttendanceReportCollectionRequest;

@JsonIgnoreType
public class OnlineMeetingRequest extends EntityRequest<OnlineMeeting> {

    public OnlineMeetingRequest(ContextPath contextPath, Optional<Object> value) {
        super(OnlineMeeting.class, contextPath, value, true);
    }

    public MeetingAttendanceReportRequest attendanceReports(String id) {
        return new MeetingAttendanceReportRequest(contextPath.addSegment("attendanceReports").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MeetingAttendanceReportCollectionRequest attendanceReports() {
        return new MeetingAttendanceReportCollectionRequest(
                        contextPath.addSegment("attendanceReports"), Optional.empty());
    }

    public MeetingAttendanceReportRequest meetingAttendanceReport() {
        return new MeetingAttendanceReportRequest(contextPath.addSegment("meetingAttendanceReport"), Optional.empty());
    }

    public MeetingRegistrationRequest registration() {
        return new MeetingRegistrationRequest(contextPath.addSegment("registration"), Optional.empty());
    }

}
