package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OnPremisesAgentGroup;
import odata.msgraph.client.beta.entity.collection.request.OnPremisesAgentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PublishedResourceCollectionRequest;

@JsonIgnoreType
public class OnPremisesAgentGroupRequest extends EntityRequest<OnPremisesAgentGroup> {

    public OnPremisesAgentGroupRequest(ContextPath contextPath, Optional<Object> value) {
        super(OnPremisesAgentGroup.class, contextPath, value, false);
    }

    public OnPremisesAgentRequest agents(String id) {
        return new OnPremisesAgentRequest(contextPath.addSegment("agents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnPremisesAgentCollectionRequest agents() {
        return new OnPremisesAgentCollectionRequest(
                        contextPath.addSegment("agents"), Optional.empty());
    }

    public PublishedResourceRequest publishedResources(String id) {
        return new PublishedResourceRequest(contextPath.addSegment("publishedResources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PublishedResourceCollectionRequest publishedResources() {
        return new PublishedResourceCollectionRequest(
                        contextPath.addSegment("publishedResources"), Optional.empty());
    }

}
