package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OfficeGraphInsights;
import odata.msgraph.client.beta.entity.collection.request.SharedInsightCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TrendingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UsedInsightCollectionRequest;

@JsonIgnoreType
public class OfficeGraphInsightsRequest extends EntityRequest<OfficeGraphInsights> {

    public OfficeGraphInsightsRequest(ContextPath contextPath, Optional<Object> value) {
        super(OfficeGraphInsights.class, contextPath, value, false);
    }

    public SharedInsightRequest shared(String id) {
        return new SharedInsightRequest(contextPath.addSegment("shared").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SharedInsightCollectionRequest shared() {
        return new SharedInsightCollectionRequest(
                        contextPath.addSegment("shared"), Optional.empty());
    }

    public TrendingRequest trending(String id) {
        return new TrendingRequest(contextPath.addSegment("trending").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TrendingCollectionRequest trending() {
        return new TrendingCollectionRequest(
                        contextPath.addSegment("trending"), Optional.empty());
    }

    public UsedInsightRequest used(String id) {
        return new UsedInsightRequest(contextPath.addSegment("used").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UsedInsightCollectionRequest used() {
        return new UsedInsightCollectionRequest(
                        contextPath.addSegment("used"), Optional.empty());
    }

}
