package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OfficeConfiguration;
import odata.msgraph.client.beta.entity.collection.request.OfficeClientConfigurationCollectionRequest;

@JsonIgnoreType
public class OfficeConfigurationRequest extends EntityRequest<OfficeConfiguration> {

    public OfficeConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(OfficeConfiguration.class, contextPath, value, false);
    }

    public OfficeClientConfigurationRequest clientConfigurations(String id) {
        return new OfficeClientConfigurationRequest(contextPath.addSegment("clientConfigurations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OfficeClientConfigurationCollectionRequest clientConfigurations() {
        return new OfficeClientConfigurationCollectionRequest(
                        contextPath.addSegment("clientConfigurations"), Optional.empty());
    }

}
