package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OfficeClientConfiguration;
import odata.msgraph.client.beta.entity.OfficeClientConfigurationAssignment;
import odata.msgraph.client.beta.entity.collection.request.OfficeClientConfigurationAssignmentCollectionRequest;

@JsonIgnoreType
public class OfficeClientConfigurationRequest extends EntityRequest<OfficeClientConfiguration> {

    public OfficeClientConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(OfficeClientConfiguration.class, contextPath, value, true);
    }

    public OfficeClientConfigurationAssignmentRequest assignments(String id) {
        return new OfficeClientConfigurationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OfficeClientConfigurationAssignmentCollectionRequest assignments() {
        return new OfficeClientConfigurationAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    @Action(name = "assign")
    @JsonIgnore
    public CollectionPageNonEntityRequest<OfficeClientConfigurationAssignment> assign(List<OfficeClientConfigurationAssignment> officeConfigurationAssignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("officeConfigurationAssignments", "Collection(microsoft.graph.officeClientConfigurationAssignment)", officeConfigurationAssignments)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), OfficeClientConfigurationAssignment.class, _parameters);
    }

}
