package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Notebook;
import odata.msgraph.client.beta.entity.OnenoteOperation;
import odata.msgraph.client.beta.entity.collection.request.OnenoteSectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SectionGroupCollectionRequest;

@JsonIgnoreType
public class NotebookRequest extends EntityRequest<Notebook> {

    public NotebookRequest(ContextPath contextPath, Optional<Object> value) {
        super(Notebook.class, contextPath, value, false);
    }

    public SectionGroupRequest sectionGroups(String id) {
        return new SectionGroupRequest(contextPath.addSegment("sectionGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SectionGroupCollectionRequest sectionGroups() {
        return new SectionGroupCollectionRequest(
                        contextPath.addSegment("sectionGroups"), Optional.empty());
    }

    public OnenoteSectionRequest sections(String id) {
        return new OnenoteSectionRequest(contextPath.addSegment("sections").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnenoteSectionCollectionRequest sections() {
        return new OnenoteSectionCollectionRequest(
                        contextPath.addSegment("sections"), Optional.empty());
    }

    @Action(name = "copyNotebook")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<OnenoteOperation> copyNotebook(String groupId, String renameAs, String notebookFolder, String siteCollectionId, String siteId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupId", "Edm.String", Checks.checkIsAscii(groupId))
            .put("renameAs", "Edm.String", Checks.checkIsAscii(renameAs))
            .put("notebookFolder", "Edm.String", Checks.checkIsAscii(notebookFolder))
            .put("siteCollectionId", "Edm.String", Checks.checkIsAscii(siteCollectionId))
            .put("siteId", "Edm.String", Checks.checkIsAscii(siteId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<OnenoteOperation>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.copyNotebook"), OnenoteOperation.class, _parameters);
    }

}
