package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MobileAppTroubleshootingEvent;
import odata.msgraph.client.beta.entity.collection.request.AppLogCollectionRequestCollectionRequest;

@JsonIgnoreType
public class MobileAppTroubleshootingEventRequest extends EntityRequest<MobileAppTroubleshootingEvent> {

    public MobileAppTroubleshootingEventRequest(ContextPath contextPath, Optional<Object> value) {
        super(MobileAppTroubleshootingEvent.class, contextPath, value, false);
    }

    public AppLogCollectionRequestRequest appLogCollectionRequests(String id) {
        return new AppLogCollectionRequestRequest(contextPath.addSegment("appLogCollectionRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppLogCollectionRequestCollectionRequest appLogCollectionRequests() {
        return new AppLogCollectionRequestCollectionRequest(
                        contextPath.addSegment("appLogCollectionRequests"), Optional.empty());
    }

}
