package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.MobileAppRelationshipState;
import odata.msgraph.client.beta.entity.MobileApp;
import odata.msgraph.client.beta.entity.MobileAppAssignment;
import odata.msgraph.client.beta.entity.MobileAppRelationship;
import odata.msgraph.client.beta.entity.collection.request.MobileAppAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppInstallStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppRelationshipCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserAppInstallStatusCollectionRequest;

@JsonIgnoreType
public class MobileAppRequest extends EntityRequest<MobileApp> {

    public MobileAppRequest(ContextPath contextPath, Optional<Object> value) {
        super(MobileApp.class, contextPath, value, false);
    }

    public MobileAppAssignmentRequest assignments(String id) {
        return new MobileAppAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileAppAssignmentCollectionRequest assignments() {
        return new MobileAppAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    public MobileAppCategoryRequest categories(String id) {
        return new MobileAppCategoryRequest(contextPath.addSegment("categories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileAppCategoryCollectionRequest categories() {
        return new MobileAppCategoryCollectionRequest(
                        contextPath.addSegment("categories"), Optional.empty());
    }

    public MobileAppInstallStatusRequest deviceStatuses(String id) {
        return new MobileAppInstallStatusRequest(contextPath.addSegment("deviceStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileAppInstallStatusCollectionRequest deviceStatuses() {
        return new MobileAppInstallStatusCollectionRequest(
                        contextPath.addSegment("deviceStatuses"), Optional.empty());
    }

    public MobileAppInstallSummaryRequest installSummary() {
        return new MobileAppInstallSummaryRequest(contextPath.addSegment("installSummary"), Optional.empty());
    }

    public MobileAppRelationshipRequest relationships(String id) {
        return new MobileAppRelationshipRequest(contextPath.addSegment("relationships").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileAppRelationshipCollectionRequest relationships() {
        return new MobileAppRelationshipCollectionRequest(
                        contextPath.addSegment("relationships"), Optional.empty());
    }

    public UserAppInstallStatusRequest userStatuses(String id) {
        return new UserAppInstallStatusRequest(contextPath.addSegment("userStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserAppInstallStatusCollectionRequest userStatuses() {
        return new UserAppInstallStatusCollectionRequest(
                        contextPath.addSegment("userStatuses"), Optional.empty());
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<MobileAppAssignment> mobileAppAssignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("mobileAppAssignments", "Collection(microsoft.graph.mobileAppAssignment)", mobileAppAssignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Action(name = "updateRelationships")
    @JsonIgnore
    public ActionRequestNoReturn updateRelationships(List<MobileAppRelationship> relationships) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("relationships", "Collection(microsoft.graph.mobileAppRelationship)", relationships)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateRelationships"), _parameters);
    }

    @Function(name = "getRelatedAppStates")
    @JsonIgnore
    public CollectionPageNonEntityRequest<MobileAppRelationshipState> getRelatedAppStates(String userPrincipalName, String deviceId) {
        Preconditions.checkNotNull(userPrincipalName, "userPrincipalName cannot be null");
        Preconditions.checkNotNull(deviceId, "deviceId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userPrincipalName", "Edm.String", Checks.checkIsAscii(userPrincipalName))
            .put("deviceId", "Edm.String", Checks.checkIsAscii(deviceId))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getRelatedAppStates"), MobileAppRelationshipState.class, _parameters);
    }

}
