package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MobileAppContent;
import odata.msgraph.client.beta.entity.collection.request.MobileAppContentFileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileContainedAppCollectionRequest;

@JsonIgnoreType
public class MobileAppContentRequest extends EntityRequest<MobileAppContent> {

    public MobileAppContentRequest(ContextPath contextPath, Optional<Object> value) {
        super(MobileAppContent.class, contextPath, value, false);
    }

    public MobileContainedAppRequest containedApps(String id) {
        return new MobileContainedAppRequest(contextPath.addSegment("containedApps").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileContainedAppCollectionRequest containedApps() {
        return new MobileContainedAppCollectionRequest(
                        contextPath.addSegment("containedApps"), Optional.empty());
    }

    public MobileAppContentFileRequest files(String id) {
        return new MobileAppContentFileRequest(contextPath.addSegment("files").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileAppContentFileCollectionRequest files() {
        return new MobileAppContentFileCollectionRequest(
                        contextPath.addSegment("files"), Optional.empty());
    }

}
