package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MicrosoftTunnelSite;
import odata.msgraph.client.beta.entity.collection.request.MicrosoftTunnelServerCollectionRequest;

@JsonIgnoreType
public class MicrosoftTunnelSiteRequest extends EntityRequest<MicrosoftTunnelSite> {

    public MicrosoftTunnelSiteRequest(ContextPath contextPath, Optional<Object> value) {
        super(MicrosoftTunnelSite.class, contextPath, value, false);
    }

    public MicrosoftTunnelConfigurationRequest microsoftTunnelConfiguration() {
        return new MicrosoftTunnelConfigurationRequest(contextPath.addSegment("microsoftTunnelConfiguration"), Optional.empty());
    }

    public MicrosoftTunnelServerRequest microsoftTunnelServers(String id) {
        return new MicrosoftTunnelServerRequest(contextPath.addSegment("microsoftTunnelServers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MicrosoftTunnelServerCollectionRequest microsoftTunnelServers() {
        return new MicrosoftTunnelServerCollectionRequest(
                        contextPath.addSegment("microsoftTunnelServers"), Optional.empty());
    }

    @Action(name = "requestUpgrade")
    @JsonIgnore
    public ActionRequestNoReturn requestUpgrade() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.requestUpgrade"), _parameters);
    }

}
