package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.KeyLongValuePair;
import odata.msgraph.client.beta.complex.MetricTimeSeriesDataPoint;
import odata.msgraph.client.beta.entity.MicrosoftTunnelServer;
import odata.msgraph.client.beta.entity.MicrosoftTunnelServerLogCollectionResponse;

@JsonIgnoreType
public class MicrosoftTunnelServerRequest extends EntityRequest<MicrosoftTunnelServer> {

    public MicrosoftTunnelServerRequest(ContextPath contextPath, Optional<Object> value) {
        super(MicrosoftTunnelServer.class, contextPath, value, false);
    }

    @Action(name = "createServerLogCollectionRequest")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<MicrosoftTunnelServerLogCollectionResponse> createServerLogCollectionRequest(OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Preconditions.checkNotNull(endDateTime, "endDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("startDateTime", "Edm.DateTimeOffset", startDateTime)
            .put("endDateTime", "Edm.DateTimeOffset", endDateTime)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<MicrosoftTunnelServerLogCollectionResponse>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createServerLogCollectionRequest"), MicrosoftTunnelServerLogCollectionResponse.class, _parameters);
    }

    @Action(name = "getHealthMetrics")
    @JsonIgnore
    public CollectionPageNonEntityRequest<KeyLongValuePair> getHealthMetrics(List<String> metricNames) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("metricNames", "Collection(Edm.String)", Checks.checkIsAscii(metricNames))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getHealthMetrics"), KeyLongValuePair.class, _parameters);
    }

    @Action(name = "getHealthMetricTimeSeries")
    @JsonIgnore
    public CollectionPageNonEntityRequest<MetricTimeSeriesDataPoint> getHealthMetricTimeSeries(String metricName, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Preconditions.checkNotNull(endDateTime, "endDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("metricName", "Edm.String", Checks.checkIsAscii(metricName))
            .put("startDateTime", "Edm.DateTimeOffset", startDateTime)
            .put("endDateTime", "Edm.DateTimeOffset", endDateTime)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getHealthMetricTimeSeries"), MetricTimeSeriesDataPoint.class, _parameters);
    }

}
