package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MeetingAttendanceReport;
import odata.msgraph.client.beta.entity.collection.request.AttendanceRecordCollectionRequest;

@JsonIgnoreType
public class MeetingAttendanceReportRequest extends EntityRequest<MeetingAttendanceReport> {

    public MeetingAttendanceReportRequest(ContextPath contextPath, Optional<Object> value) {
        super(MeetingAttendanceReport.class, contextPath, value, false);
    }

    public AttendanceRecordRequest attendanceRecords(String id) {
        return new AttendanceRecordRequest(contextPath.addSegment("attendanceRecords").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AttendanceRecordCollectionRequest attendanceRecords() {
        return new AttendanceRecordCollectionRequest(
                        contextPath.addSegment("attendanceRecords"), Optional.empty());
    }

}
