package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ManagedAppRegistration;
import odata.msgraph.client.beta.entity.collection.request.ManagedAppOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedAppPolicyCollectionRequest;

@JsonIgnoreType
public class ManagedAppRegistrationRequest extends EntityRequest<ManagedAppRegistration> {

    public ManagedAppRegistrationRequest(ContextPath contextPath, Optional<Object> value) {
        super(ManagedAppRegistration.class, contextPath, value, false);
    }

    public ManagedAppPolicyRequest appliedPolicies(String id) {
        return new ManagedAppPolicyRequest(contextPath.addSegment("appliedPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedAppPolicyCollectionRequest appliedPolicies() {
        return new ManagedAppPolicyCollectionRequest(
                        contextPath.addSegment("appliedPolicies"), Optional.empty());
    }

    public ManagedAppPolicyRequest intendedPolicies(String id) {
        return new ManagedAppPolicyRequest(contextPath.addSegment("intendedPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedAppPolicyCollectionRequest intendedPolicies() {
        return new ManagedAppPolicyCollectionRequest(
                        contextPath.addSegment("intendedPolicies"), Optional.empty());
    }

    public ManagedAppOperationRequest operations(String id) {
        return new ManagedAppOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedAppOperationCollectionRequest operations() {
        return new ManagedAppOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.empty());
    }

}
