package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MacOSSoftwareUpdateAccountSummary;
import odata.msgraph.client.beta.entity.collection.request.MacOSSoftwareUpdateCategorySummaryCollectionRequest;

@JsonIgnoreType
public class MacOSSoftwareUpdateAccountSummaryRequest extends EntityRequest<MacOSSoftwareUpdateAccountSummary> {

    public MacOSSoftwareUpdateAccountSummaryRequest(ContextPath contextPath, Optional<Object> value) {
        super(MacOSSoftwareUpdateAccountSummary.class, contextPath, value, false);
    }

    public MacOSSoftwareUpdateCategorySummaryRequest categorySummaries(String id) {
        return new MacOSSoftwareUpdateCategorySummaryRequest(contextPath.addSegment("categorySummaries").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MacOSSoftwareUpdateCategorySummaryCollectionRequest categorySummaries() {
        return new MacOSSoftwareUpdateCategorySummaryCollectionRequest(
                        contextPath.addSegment("categorySummaries"), Optional.empty());
    }

}
