package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.MacOSPkcsCertificateProfile;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceCertificateStateCollectionRequest;

@JsonIgnoreType
public class MacOSPkcsCertificateProfileRequest extends EntityRequest<MacOSPkcsCertificateProfile> {

    public MacOSPkcsCertificateProfileRequest(ContextPath contextPath, Optional<Object> value) {
        super(MacOSPkcsCertificateProfile.class, contextPath, value, false);
    }

    public ManagedDeviceCertificateStateRequest managedDeviceCertificateStates(String id) {
        return new ManagedDeviceCertificateStateRequest(contextPath.addSegment("managedDeviceCertificateStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedDeviceCertificateStateCollectionRequest managedDeviceCertificateStates() {
        return new ManagedDeviceCertificateStateCollectionRequest(
                        contextPath.addSegment("managedDeviceCertificateStates"), Optional.empty());
    }

}
