package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.List;
import odata.msgraph.client.beta.entity.collection.request.ColumnDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ContentTypeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemActivityOLDCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ListItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RichLongRunningOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SubscriptionCollectionRequest;

@JsonIgnoreType
public class ListRequest extends EntityRequest<List> {

    public ListRequest(ContextPath contextPath, Optional<Object> value) {
        super(List.class, contextPath, value, false);
    }

    public ItemActivityOLDRequest activities(String id) {
        return new ItemActivityOLDRequest(contextPath.addSegment("activities").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ItemActivityOLDCollectionRequest activities() {
        return new ItemActivityOLDCollectionRequest(
                        contextPath.addSegment("activities"), Optional.empty());
    }

    public ColumnDefinitionRequest columns(String id) {
        return new ColumnDefinitionRequest(contextPath.addSegment("columns").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ColumnDefinitionCollectionRequest columns() {
        return new ColumnDefinitionCollectionRequest(
                        contextPath.addSegment("columns"), Optional.empty());
    }

    public ContentTypeRequest contentTypes(String id) {
        return new ContentTypeRequest(contextPath.addSegment("contentTypes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ContentTypeCollectionRequest contentTypes() {
        return new ContentTypeCollectionRequest(
                        contextPath.addSegment("contentTypes"), Optional.empty());
    }

    public DriveRequest drive() {
        return new DriveRequest(contextPath.addSegment("drive"), Optional.empty());
    }

    public ListItemRequest items(String id) {
        return new ListItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ListItemCollectionRequest items() {
        return new ListItemCollectionRequest(
                        contextPath.addSegment("items"), Optional.empty());
    }

    public RichLongRunningOperationRequest operations(String id) {
        return new RichLongRunningOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RichLongRunningOperationCollectionRequest operations() {
        return new RichLongRunningOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.empty());
    }

    public SubscriptionRequest subscriptions(String id) {
        return new SubscriptionRequest(contextPath.addSegment("subscriptions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SubscriptionCollectionRequest subscriptions() {
        return new SubscriptionCollectionRequest(
                        contextPath.addSegment("subscriptions"), Optional.empty());
    }

}
