package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DriveRecipient;
import odata.msgraph.client.beta.entity.ItemActivityStat;
import odata.msgraph.client.beta.entity.ListItem;
import odata.msgraph.client.beta.entity.Permission;
import odata.msgraph.client.beta.entity.collection.request.ItemActivityOLDCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ListItemVersionCollectionRequest;

@JsonIgnoreType
public class ListItemRequest extends EntityRequest<ListItem> {

    public ListItemRequest(ContextPath contextPath, Optional<Object> value) {
        super(ListItem.class, contextPath, value, false);
    }

    public ItemActivityOLDRequest activities(String id) {
        return new ItemActivityOLDRequest(contextPath.addSegment("activities").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ItemActivityOLDCollectionRequest activities() {
        return new ItemActivityOLDCollectionRequest(
                        contextPath.addSegment("activities"), Optional.empty());
    }

    public ItemAnalyticsRequest analytics() {
        return new ItemAnalyticsRequest(contextPath.addSegment("analytics"), Optional.empty());
    }

    public DriveItemRequest driveItem() {
        return new DriveItemRequest(contextPath.addSegment("driveItem"), Optional.empty());
    }

    public FieldValueSetRequest fields() {
        return new FieldValueSetRequest(contextPath.addSegment("fields"), Optional.empty());
    }

    public ListItemVersionRequest versions(String id) {
        return new ListItemVersionRequest(contextPath.addSegment("versions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ListItemVersionCollectionRequest versions() {
        return new ListItemVersionCollectionRequest(
                        contextPath.addSegment("versions"), Optional.empty());
    }

    @Action(name = "createLink")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Permission> createLink(String type, String scope, OffsetDateTime expirationDateTime, String password, List<DriveRecipient> recipients, Boolean retainInheritedPermissions) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("type", "Edm.String", Checks.checkIsAscii(type))
            .put("scope", "Edm.String", Checks.checkIsAscii(scope))
            .put("expirationDateTime", "Edm.DateTimeOffset", expirationDateTime)
            .put("password", "Edm.String", Checks.checkIsAscii(password))
            .put("recipients", "Collection(microsoft.graph.driveRecipient)", recipients)
            .put("retainInheritedPermissions", "Edm.Boolean", retainInheritedPermissions)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Permission>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createLink"), Permission.class, _parameters);
    }

    @Function(name = "getActivitiesByInterval")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ItemActivityStat> getActivitiesByInterval(String startDateTime, String endDateTime, String interval) {
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Preconditions.checkNotNull(endDateTime, "endDateTime cannot be null");
        Preconditions.checkNotNull(interval, "interval cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("startDateTime", "Edm.String", Checks.checkIsAscii(startDateTime))
            .put("endDateTime", "Edm.String", Checks.checkIsAscii(endDateTime))
            .put("interval", "Edm.String", Checks.checkIsAscii(interval))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getActivitiesByInterval"), ItemActivityStat.class, _parameters);
    }

}
