package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Item;
import odata.msgraph.client.beta.entity.collection.request.PictureCollectionRequest;

@JsonIgnoreType
public class ItemRequest extends EntityRequest<Item> {

    public ItemRequest(ContextPath contextPath, Optional<Object> value) {
        super(Item.class, contextPath, value, false);
    }

    public ItemCategoryRequest itemCategory() {
        return new ItemCategoryRequest(contextPath.addSegment("itemCategory"), Optional.empty());
    }

    public PictureRequest picture(String id) {
        return new PictureRequest(contextPath.addSegment("picture").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PictureCollectionRequest picture() {
        return new PictureCollectionRequest(
                        contextPath.addSegment("picture"), Optional.empty());
    }

}
