package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ItemAnalytics;
import odata.msgraph.client.beta.entity.collection.request.ItemActivityStatCollectionRequest;

@JsonIgnoreType
public class ItemAnalyticsRequest extends EntityRequest<ItemAnalytics> {

    public ItemAnalyticsRequest(ContextPath contextPath, Optional<Object> value) {
        super(ItemAnalytics.class, contextPath, value, false);
    }

    public ItemActivityStatRequest allTime() {
        return new ItemActivityStatRequest(contextPath.addSegment("allTime"), Optional.empty());
    }

    public ItemActivityStatRequest itemActivityStats(String id) {
        return new ItemActivityStatRequest(contextPath.addSegment("itemActivityStats").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ItemActivityStatCollectionRequest itemActivityStats() {
        return new ItemActivityStatCollectionRequest(
                        contextPath.addSegment("itemActivityStats"), Optional.empty());
    }

    public ItemActivityStatRequest lastSevenDays() {
        return new ItemActivityStatRequest(contextPath.addSegment("lastSevenDays"), Optional.empty());
    }

}
