package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.IosVppApp;
import odata.msgraph.client.beta.entity.collection.request.IosVppAppAssignedLicenseCollectionRequest;

@JsonIgnoreType
public class IosVppAppRequest extends EntityRequest<IosVppApp> {

    public IosVppAppRequest(ContextPath contextPath, Optional<Object> value) {
        super(IosVppApp.class, contextPath, value, false);
    }

    public IosVppAppAssignedLicenseRequest assignedLicenses(String id) {
        return new IosVppAppAssignedLicenseRequest(contextPath.addSegment("assignedLicenses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IosVppAppAssignedLicenseCollectionRequest assignedLicenses() {
        return new IosVppAppAssignedLicenseCollectionRequest(
                        contextPath.addSegment("assignedLicenses"), Optional.empty());
    }

    @Action(name = "revokeAllLicenses")
    @JsonIgnore
    public ActionRequestNoReturn revokeAllLicenses(Boolean notifyManagedDevices) {
        Preconditions.checkNotNull(notifyManagedDevices, "notifyManagedDevices cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("notifyManagedDevices", "Edm.Boolean", notifyManagedDevices)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.revokeAllLicenses"), _parameters);
    }

    @Action(name = "revokeDeviceLicense")
    @JsonIgnore
    public ActionRequestNoReturn revokeDeviceLicense(String managedDeviceId, Boolean notifyManagedDevices) {
        Preconditions.checkNotNull(notifyManagedDevices, "notifyManagedDevices cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("managedDeviceId", "Edm.String", Checks.checkIsAscii(managedDeviceId))
            .put("notifyManagedDevices", "Edm.Boolean", notifyManagedDevices)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.revokeDeviceLicense"), _parameters);
    }

    @Action(name = "revokeUserLicense")
    @JsonIgnore
    public ActionRequestNoReturn revokeUserLicense(String userId, Boolean notifyManagedDevices) {
        Preconditions.checkNotNull(notifyManagedDevices, "notifyManagedDevices cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userId", "Edm.String", Checks.checkIsAscii(userId))
            .put("notifyManagedDevices", "Edm.Boolean", notifyManagedDevices)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.revokeUserLicense"), _parameters);
    }

}
