package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.IosEasEmailProfileConfiguration;

@JsonIgnoreType
public class IosEasEmailProfileConfigurationRequest extends EntityRequest<IosEasEmailProfileConfiguration> {

    public IosEasEmailProfileConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(IosEasEmailProfileConfiguration.class, contextPath, value, false);
    }

    public DeviceManagementDerivedCredentialSettingsRequest derivedCredentialSettings() {
        return new DeviceManagementDerivedCredentialSettingsRequest(contextPath.addSegment("derivedCredentialSettings"), Optional.empty());
    }

    public IosCertificateProfileBaseRequest identityCertificate() {
        return new IosCertificateProfileBaseRequest(contextPath.addSegment("identityCertificate"), Optional.empty());
    }

    public IosCertificateProfileRequest smimeEncryptionCertificate() {
        return new IosCertificateProfileRequest(contextPath.addSegment("smimeEncryptionCertificate"), Optional.empty());
    }

    public IosCertificateProfileRequest smimeSigningCertificate() {
        return new IosCertificateProfileRequest(contextPath.addSegment("smimeSigningCertificate"), Optional.empty());
    }

}
