package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.IosDeviceFeaturesConfiguration;

@JsonIgnoreType
public class IosDeviceFeaturesConfigurationRequest extends EntityRequest<IosDeviceFeaturesConfiguration> {

    public IosDeviceFeaturesConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(IosDeviceFeaturesConfiguration.class, contextPath, value, false);
    }

    public IosCertificateProfileBaseRequest identityCertificateForClientAuthentication() {
        return new IosCertificateProfileBaseRequest(contextPath.addSegment("identityCertificateForClientAuthentication"), Optional.empty());
    }

    public IosCertificateProfileBaseRequest singleSignOnExtensionPkinitCertificate() {
        return new IosCertificateProfileBaseRequest(contextPath.addSegment("singleSignOnExtensionPkinitCertificate"), Optional.empty());
    }

}
