package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.InferenceClassification;
import odata.msgraph.client.beta.entity.collection.request.InferenceClassificationOverrideCollectionRequest;

@JsonIgnoreType
public class InferenceClassificationRequest extends EntityRequest<InferenceClassification> {

    public InferenceClassificationRequest(ContextPath contextPath, Optional<Object> value) {
        super(InferenceClassification.class, contextPath, value, false);
    }

    public InferenceClassificationOverrideRequest overrides(String id) {
        return new InferenceClassificationOverrideRequest(contextPath.addSegment("overrides").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public InferenceClassificationOverrideCollectionRequest overrides() {
        return new InferenceClassificationOverrideCollectionRequest(
                        contextPath.addSegment("overrides"), Optional.empty());
    }

}
