package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ImportedWindowsAutopilotDeviceIdentityUpload;
import odata.msgraph.client.beta.entity.collection.request.ImportedWindowsAutopilotDeviceIdentityCollectionRequest;

@JsonIgnoreType
public class ImportedWindowsAutopilotDeviceIdentityUploadRequest extends EntityRequest<ImportedWindowsAutopilotDeviceIdentityUpload> {

    public ImportedWindowsAutopilotDeviceIdentityUploadRequest(ContextPath contextPath, Optional<Object> value) {
        super(ImportedWindowsAutopilotDeviceIdentityUpload.class, contextPath, value, false);
    }

    public ImportedWindowsAutopilotDeviceIdentityRequest deviceIdentities(String id) {
        return new ImportedWindowsAutopilotDeviceIdentityRequest(contextPath.addSegment("deviceIdentities").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ImportedWindowsAutopilotDeviceIdentityCollectionRequest deviceIdentities() {
        return new ImportedWindowsAutopilotDeviceIdentityCollectionRequest(
                        contextPath.addSegment("deviceIdentities"), Optional.empty());
    }

}
