package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.IdentityProtectionRoot;
import odata.msgraph.client.beta.entity.collection.request.RiskDetectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RiskyServicePrincipalCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RiskyUserCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ServicePrincipalRiskDetectionCollectionRequest;

@JsonIgnoreType
public class IdentityProtectionRootRequest extends EntityRequest<IdentityProtectionRoot> {

    public IdentityProtectionRootRequest(ContextPath contextPath, Optional<Object> value) {
        super(IdentityProtectionRoot.class, contextPath, value, false);
    }

    public RiskDetectionRequest riskDetections(String id) {
        return new RiskDetectionRequest(contextPath.addSegment("riskDetections").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RiskDetectionCollectionRequest riskDetections() {
        return new RiskDetectionCollectionRequest(
                        contextPath.addSegment("riskDetections"), Optional.empty());
    }

    public RiskyServicePrincipalRequest riskyServicePrincipals(String id) {
        return new RiskyServicePrincipalRequest(contextPath.addSegment("riskyServicePrincipals").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RiskyServicePrincipalCollectionRequest riskyServicePrincipals() {
        return new RiskyServicePrincipalCollectionRequest(
                        contextPath.addSegment("riskyServicePrincipals"), Optional.empty());
    }

    public RiskyUserRequest riskyUsers(String id) {
        return new RiskyUserRequest(contextPath.addSegment("riskyUsers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RiskyUserCollectionRequest riskyUsers() {
        return new RiskyUserCollectionRequest(
                        contextPath.addSegment("riskyUsers"), Optional.empty());
    }

    public ServicePrincipalRiskDetectionRequest servicePrincipalRiskDetections(String id) {
        return new ServicePrincipalRiskDetectionRequest(contextPath.addSegment("servicePrincipalRiskDetections").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ServicePrincipalRiskDetectionCollectionRequest servicePrincipalRiskDetections() {
        return new ServicePrincipalRiskDetectionCollectionRequest(
                        contextPath.addSegment("servicePrincipalRiskDetections"), Optional.empty());
    }

}
