package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.IdentityContainer;
import odata.msgraph.client.beta.entity.collection.request.B2cIdentityUserFlowCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.B2xIdentityUserFlowCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IdentityApiConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IdentityProviderBaseCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IdentityUserFlowAttributeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IdentityUserFlowCollectionRequest;

@JsonIgnoreType
public class IdentityContainerRequest extends EntityRequest<IdentityContainer> {

    public IdentityContainerRequest(ContextPath contextPath, Optional<Object> value) {
        super(IdentityContainer.class, contextPath, value, false);
    }

    public ConditionalAccessRootRequest conditionalAccess() {
        return new ConditionalAccessRootRequest(contextPath.addSegment("conditionalAccess"), Optional.empty());
    }

    public IdentityApiConnectorRequest apiConnectors(String id) {
        return new IdentityApiConnectorRequest(contextPath.addSegment("apiConnectors").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IdentityApiConnectorCollectionRequest apiConnectors() {
        return new IdentityApiConnectorCollectionRequest(
                        contextPath.addSegment("apiConnectors"), Optional.empty());
    }

    public B2cIdentityUserFlowRequest b2cUserFlows(String id) {
        return new B2cIdentityUserFlowRequest(contextPath.addSegment("b2cUserFlows").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public B2cIdentityUserFlowCollectionRequest b2cUserFlows() {
        return new B2cIdentityUserFlowCollectionRequest(
                        contextPath.addSegment("b2cUserFlows"), Optional.empty());
    }

    public B2xIdentityUserFlowRequest b2xUserFlows(String id) {
        return new B2xIdentityUserFlowRequest(contextPath.addSegment("b2xUserFlows").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public B2xIdentityUserFlowCollectionRequest b2xUserFlows() {
        return new B2xIdentityUserFlowCollectionRequest(
                        contextPath.addSegment("b2xUserFlows"), Optional.empty());
    }

    public IdentityProviderBaseRequest identityProviders(String id) {
        return new IdentityProviderBaseRequest(contextPath.addSegment("identityProviders").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IdentityProviderBaseCollectionRequest identityProviders() {
        return new IdentityProviderBaseCollectionRequest(
                        contextPath.addSegment("identityProviders"), Optional.empty());
    }

    public IdentityUserFlowAttributeRequest userFlowAttributes(String id) {
        return new IdentityUserFlowAttributeRequest(contextPath.addSegment("userFlowAttributes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IdentityUserFlowAttributeCollectionRequest userFlowAttributes() {
        return new IdentityUserFlowAttributeCollectionRequest(
                        contextPath.addSegment("userFlowAttributes"), Optional.empty());
    }

    public IdentityUserFlowRequest userFlows(String id) {
        return new IdentityUserFlowRequest(contextPath.addSegment("userFlows").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IdentityUserFlowCollectionRequest userFlows() {
        return new IdentityUserFlowCollectionRequest(
                        contextPath.addSegment("userFlows"), Optional.empty());
    }

    public ContinuousAccessEvaluationPolicyRequest continuousAccessEvaluationPolicy() {
        return new ContinuousAccessEvaluationPolicyRequest(contextPath.addSegment("continuousAccessEvaluationPolicy"), Optional.empty());
    }

}
