package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.complex.AssignedLicense;
import odata.msgraph.client.beta.complex.EvaluateDynamicMembershipResult;
import odata.msgraph.client.beta.entity.Group;
import odata.msgraph.client.beta.entity.ResourceSpecificPermissionGrant;
import odata.msgraph.client.beta.entity.collection.request.AppRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConversationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConversationThreadCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DirectorySettingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DriveCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EndpointCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupLifecyclePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ProfilePhotoCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ResourceSpecificPermissionGrantCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SiteCollectionRequest;

@JsonIgnoreType
public class GroupRequest extends EntityRequest<Group> {

    public GroupRequest(ContextPath contextPath, Optional<Object> value) {
        super(Group.class, contextPath, value, false);
    }

    public AppRoleAssignmentRequest appRoleAssignments(String id) {
        return new AppRoleAssignmentRequest(contextPath.addSegment("appRoleAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppRoleAssignmentCollectionRequest appRoleAssignments() {
        return new AppRoleAssignmentCollectionRequest(
                        contextPath.addSegment("appRoleAssignments"), Optional.empty());
    }

    public DirectoryObjectRequest createdOnBehalfOf() {
        return new DirectoryObjectRequest(contextPath.addSegment("createdOnBehalfOf"), Optional.empty());
    }

    public EndpointRequest endpoints(String id) {
        return new EndpointRequest(contextPath.addSegment("endpoints").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EndpointCollectionRequest endpoints() {
        return new EndpointCollectionRequest(
                        contextPath.addSegment("endpoints"), Optional.empty());
    }

    public DirectoryObjectRequest memberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("memberOf").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest memberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("memberOf"), Optional.empty());
    }

    public DirectoryObjectRequest members(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest members() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("members"), Optional.empty());
    }

    public DirectoryObjectRequest membersWithLicenseErrors(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("membersWithLicenseErrors").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest membersWithLicenseErrors() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("membersWithLicenseErrors"), Optional.empty());
    }

    public DirectoryObjectRequest owners(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("owners").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest owners() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("owners"), Optional.empty());
    }

    public ResourceSpecificPermissionGrantRequest permissionGrants(String id) {
        return new ResourceSpecificPermissionGrantRequest(contextPath.addSegment("permissionGrants").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ResourceSpecificPermissionGrantCollectionRequest permissionGrants() {
        return new ResourceSpecificPermissionGrantCollectionRequest(
                        contextPath.addSegment("permissionGrants"), Optional.empty());
    }

    public DirectorySettingRequest settings(String id) {
        return new DirectorySettingRequest(contextPath.addSegment("settings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectorySettingCollectionRequest settings() {
        return new DirectorySettingCollectionRequest(
                        contextPath.addSegment("settings"), Optional.empty());
    }

    public DirectoryObjectRequest transitiveMemberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("transitiveMemberOf").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest transitiveMemberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("transitiveMemberOf"), Optional.empty());
    }

    public DirectoryObjectRequest transitiveMembers(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("transitiveMembers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest transitiveMembers() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("transitiveMembers"), Optional.empty());
    }

    public DirectoryObjectRequest acceptedSenders(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("acceptedSenders").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest acceptedSenders() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("acceptedSenders"), Optional.empty());
    }

    public CalendarRequest calendar() {
        return new CalendarRequest(contextPath.addSegment("calendar"), Optional.empty());
    }

    public EventRequest calendarView(String id) {
        return new EventRequest(contextPath.addSegment("calendarView").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EventCollectionRequest calendarView() {
        return new EventCollectionRequest(
                        contextPath.addSegment("calendarView"), Optional.empty());
    }

    public ConversationRequest conversations(String id) {
        return new ConversationRequest(contextPath.addSegment("conversations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConversationCollectionRequest conversations() {
        return new ConversationCollectionRequest(
                        contextPath.addSegment("conversations"), Optional.empty());
    }

    public EventRequest events(String id) {
        return new EventRequest(contextPath.addSegment("events").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EventCollectionRequest events() {
        return new EventCollectionRequest(
                        contextPath.addSegment("events"), Optional.empty());
    }

    public DirectoryObjectRequest rejectedSenders(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("rejectedSenders").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest rejectedSenders() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("rejectedSenders"), Optional.empty());
    }

    public ConversationThreadRequest threads(String id) {
        return new ConversationThreadRequest(contextPath.addSegment("threads").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConversationThreadCollectionRequest threads() {
        return new ConversationThreadCollectionRequest(
                        contextPath.addSegment("threads"), Optional.empty());
    }

    public DriveRequest drive() {
        return new DriveRequest(contextPath.addSegment("drive"), Optional.empty());
    }

    public DriveRequest drives(String id) {
        return new DriveRequest(contextPath.addSegment("drives").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DriveCollectionRequest drives() {
        return new DriveCollectionRequest(
                        contextPath.addSegment("drives"), Optional.empty());
    }

    public SiteRequest sites(String id) {
        return new SiteRequest(contextPath.addSegment("sites").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SiteCollectionRequest sites() {
        return new SiteCollectionRequest(
                        contextPath.addSegment("sites"), Optional.empty());
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"), Optional.empty());
    }

    public GroupLifecyclePolicyRequest groupLifecyclePolicies(String id) {
        return new GroupLifecyclePolicyRequest(contextPath.addSegment("groupLifecyclePolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupLifecyclePolicyCollectionRequest groupLifecyclePolicies() {
        return new GroupLifecyclePolicyCollectionRequest(
                        contextPath.addSegment("groupLifecyclePolicies"), Optional.empty());
    }

    public PlannerGroupRequest planner() {
        return new PlannerGroupRequest(contextPath.addSegment("planner"), Optional.empty());
    }

    public OnenoteRequest onenote() {
        return new OnenoteRequest(contextPath.addSegment("onenote"), Optional.empty());
    }

    public ProfilePhotoRequest photo() {
        return new ProfilePhotoRequest(contextPath.addSegment("photo"), Optional.empty());
    }

    public ProfilePhotoRequest photos(String id) {
        return new ProfilePhotoRequest(contextPath.addSegment("photos").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ProfilePhotoCollectionRequest photos() {
        return new ProfilePhotoCollectionRequest(
                        contextPath.addSegment("photos"), Optional.empty());
    }

    public TeamRequest team() {
        return new TeamRequest(contextPath.addSegment("team"), Optional.empty());
    }

    @Action(name = "assignLicense")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Group> assignLicense(List<AssignedLicense> addLicenses, List<UUID> removeLicenses) {
        Preconditions.checkNotNull(addLicenses, "addLicenses cannot be null");
        Preconditions.checkNotNull(removeLicenses, "removeLicenses cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("addLicenses", "Collection(microsoft.graph.assignedLicense)", addLicenses)
            .put("removeLicenses", "Collection(Edm.Guid)", removeLicenses)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Group>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assignLicense"), Group.class, _parameters);
    }

    @Action(name = "checkGrantedPermissionsForApp")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ResourceSpecificPermissionGrant> checkGrantedPermissionsForApp() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.checkGrantedPermissionsForApp"), ResourceSpecificPermissionGrant.class, _parameters);
    }

    @Action(name = "validateProperties")
    @JsonIgnore
    public ActionRequestNoReturn validateProperties(String displayName, String mailNickname, UUID onBehalfOfUserId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("displayName", "Edm.String", Checks.checkIsAscii(displayName))
            .put("mailNickname", "Edm.String", Checks.checkIsAscii(mailNickname))
            .put("onBehalfOfUserId", "Edm.Guid", onBehalfOfUserId)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.validateProperties"), _parameters);
    }

    @Action(name = "addFavorite")
    @JsonIgnore
    public ActionRequestNoReturn addFavorite() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.addFavorite"), _parameters);
    }

    @Action(name = "removeFavorite")
    @JsonIgnore
    public ActionRequestNoReturn removeFavorite() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.removeFavorite"), _parameters);
    }

    @Action(name = "resetUnseenCount")
    @JsonIgnore
    public ActionRequestNoReturn resetUnseenCount() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.resetUnseenCount"), _parameters);
    }

    @Action(name = "subscribeByMail")
    @JsonIgnore
    public ActionRequestNoReturn subscribeByMail() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.subscribeByMail"), _parameters);
    }

    @Action(name = "unsubscribeByMail")
    @JsonIgnore
    public ActionRequestNoReturn unsubscribeByMail() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unsubscribeByMail"), _parameters);
    }

    @Action(name = "evaluateDynamicMembership")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EvaluateDynamicMembershipResult> evaluateDynamicMembership(String memberId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("memberId", "Edm.String", Checks.checkIsAscii(memberId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<EvaluateDynamicMembershipResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.evaluateDynamicMembership"), EvaluateDynamicMembershipResult.class, _parameters);
    }

    @Action(name = "renew")
    @JsonIgnore
    public ActionRequestNoReturn renew() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.renew"), _parameters);
    }

}
