package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.GroupPolicyPresentationValue;

@JsonIgnoreType
public class GroupPolicyPresentationValueRequest extends EntityRequest<GroupPolicyPresentationValue> {

    public GroupPolicyPresentationValueRequest(ContextPath contextPath, Optional<Object> value) {
        super(GroupPolicyPresentationValue.class, contextPath, value, false);
    }

    public GroupPolicyDefinitionValueRequest definitionValue() {
        return new GroupPolicyDefinitionValueRequest(contextPath.addSegment("definitionValue"), Optional.empty());
    }

    public GroupPolicyPresentationRequest presentation() {
        return new GroupPolicyPresentationRequest(contextPath.addSegment("presentation"), Optional.empty());
    }

}
