package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.GroupPolicyDefinitionValue;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyPresentationValueCollectionRequest;

@JsonIgnoreType
public class GroupPolicyDefinitionValueRequest extends EntityRequest<GroupPolicyDefinitionValue> {

    public GroupPolicyDefinitionValueRequest(ContextPath contextPath, Optional<Object> value) {
        super(GroupPolicyDefinitionValue.class, contextPath, value, false);
    }

    public GroupPolicyDefinitionRequest definition() {
        return new GroupPolicyDefinitionRequest(contextPath.addSegment("definition"), Optional.empty());
    }

    public GroupPolicyPresentationValueRequest presentationValues(String id) {
        return new GroupPolicyPresentationValueRequest(contextPath.addSegment("presentationValues").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicyPresentationValueCollectionRequest presentationValues() {
        return new GroupPolicyPresentationValueCollectionRequest(
                        contextPath.addSegment("presentationValues"), Optional.empty());
    }

}
