package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.GroupPolicyDefinition;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyPresentationCollectionRequest;

@JsonIgnoreType
public class GroupPolicyDefinitionRequest extends EntityRequest<GroupPolicyDefinition> {

    public GroupPolicyDefinitionRequest(ContextPath contextPath, Optional<Object> value) {
        super(GroupPolicyDefinition.class, contextPath, value, false);
    }

    public GroupPolicyCategoryRequest category() {
        return new GroupPolicyCategoryRequest(contextPath.addSegment("category"), Optional.empty());
    }

    public GroupPolicyDefinitionFileRequest definitionFile() {
        return new GroupPolicyDefinitionFileRequest(contextPath.addSegment("definitionFile"), Optional.empty());
    }

    public GroupPolicyDefinitionRequest nextVersionDefinition() {
        return new GroupPolicyDefinitionRequest(contextPath.addSegment("nextVersionDefinition"), Optional.empty());
    }

    public GroupPolicyPresentationRequest presentations(String id) {
        return new GroupPolicyPresentationRequest(contextPath.addSegment("presentations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicyPresentationCollectionRequest presentations() {
        return new GroupPolicyPresentationCollectionRequest(
                        contextPath.addSegment("presentations"), Optional.empty());
    }

    public GroupPolicyDefinitionRequest previousVersionDefinition() {
        return new GroupPolicyDefinitionRequest(contextPath.addSegment("previousVersionDefinition"), Optional.empty());
    }

}
