package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.GroupPolicyDefinitionFile;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyDefinitionCollectionRequest;

@JsonIgnoreType
public class GroupPolicyDefinitionFileRequest extends EntityRequest<GroupPolicyDefinitionFile> {

    public GroupPolicyDefinitionFileRequest(ContextPath contextPath, Optional<Object> value) {
        super(GroupPolicyDefinitionFile.class, contextPath, value, false);
    }

    public GroupPolicyDefinitionRequest definitions(String id) {
        return new GroupPolicyDefinitionRequest(contextPath.addSegment("definitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicyDefinitionCollectionRequest definitions() {
        return new GroupPolicyDefinitionCollectionRequest(
                        contextPath.addSegment("definitions"), Optional.empty());
    }

}
