package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.GroupPolicyCategory;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyDefinitionCollectionRequest;

@JsonIgnoreType
public class GroupPolicyCategoryRequest extends EntityRequest<GroupPolicyCategory> {

    public GroupPolicyCategoryRequest(ContextPath contextPath, Optional<Object> value) {
        super(GroupPolicyCategory.class, contextPath, value, false);
    }

    public GroupPolicyCategoryRequest children(String id) {
        return new GroupPolicyCategoryRequest(contextPath.addSegment("children").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicyCategoryCollectionRequest children() {
        return new GroupPolicyCategoryCollectionRequest(
                        contextPath.addSegment("children"), Optional.empty());
    }

    public GroupPolicyDefinitionFileRequest definitionFile() {
        return new GroupPolicyDefinitionFileRequest(contextPath.addSegment("definitionFile"), Optional.empty());
    }

    public GroupPolicyDefinitionRequest definitions(String id) {
        return new GroupPolicyDefinitionRequest(contextPath.addSegment("definitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicyDefinitionCollectionRequest definitions() {
        return new GroupPolicyDefinitionCollectionRequest(
                        contextPath.addSegment("definitions"), Optional.empty());
    }

    public GroupPolicyCategoryRequest parent() {
        return new GroupPolicyCategoryRequest(contextPath.addSegment("parent"), Optional.empty());
    }

}
