package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.GovernanceRoleDefinition;

@JsonIgnoreType
public class GovernanceRoleDefinitionRequest extends EntityRequest<GovernanceRoleDefinition> {

    public GovernanceRoleDefinitionRequest(ContextPath contextPath, Optional<Object> value) {
        super(GovernanceRoleDefinition.class, contextPath, value, false);
    }

    public GovernanceResourceRequest resource() {
        return new GovernanceResourceRequest(contextPath.addSegment("resource"), Optional.empty());
    }

    public GovernanceRoleSettingRequest roleSetting() {
        return new GovernanceRoleSettingRequest(contextPath.addSegment("roleSetting"), Optional.empty());
    }

}
