package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.GovernanceSchedule;
import odata.msgraph.client.beta.entity.GovernanceRoleAssignmentRequest;

@JsonIgnoreType
public class GovernanceRoleAssignmentRequestRequest extends EntityRequest<GovernanceRoleAssignmentRequest> {

    public GovernanceRoleAssignmentRequestRequest(ContextPath contextPath, Optional<Object> value) {
        super(GovernanceRoleAssignmentRequest.class, contextPath, value, false);
    }

    public GovernanceResourceRequest resource() {
        return new GovernanceResourceRequest(contextPath.addSegment("resource"), Optional.empty());
    }

    public GovernanceRoleDefinitionRequest roleDefinition() {
        return new GovernanceRoleDefinitionRequest(contextPath.addSegment("roleDefinition"), Optional.empty());
    }

    public GovernanceSubjectRequest subject() {
        return new GovernanceSubjectRequest(contextPath.addSegment("subject"), Optional.empty());
    }

    @Action(name = "cancel")
    @JsonIgnore
    public ActionRequestNoReturn cancel() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancel"), _parameters);
    }

    @Action(name = "updateRequest")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<GovernanceRoleAssignmentRequest> updateRequest(String decision, String assignmentState, GovernanceSchedule schedule, String reason) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("decision", "Edm.String", Checks.checkIsAscii(decision))
            .put("assignmentState", "Edm.String", Checks.checkIsAscii(assignmentState))
            .put("schedule", "microsoft.graph.governanceSchedule", schedule)
            .put("reason", "Edm.String", Checks.checkIsAscii(reason))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<GovernanceRoleAssignmentRequest>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateRequest"), GovernanceRoleAssignmentRequest.class, _parameters);
    }

}
