package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.GovernanceRoleAssignment;

@JsonIgnoreType
public class GovernanceRoleAssignmentRequest extends EntityRequest<GovernanceRoleAssignment> {

    public GovernanceRoleAssignmentRequest(ContextPath contextPath, Optional<Object> value) {
        super(GovernanceRoleAssignment.class, contextPath, value, false);
    }

    public GovernanceRoleAssignmentRequest linkedEligibleRoleAssignment() {
        return new GovernanceRoleAssignmentRequest(contextPath.addSegment("linkedEligibleRoleAssignment"), Optional.empty());
    }

    public GovernanceResourceRequest resource() {
        return new GovernanceResourceRequest(contextPath.addSegment("resource"), Optional.empty());
    }

    public GovernanceRoleDefinitionRequest roleDefinition() {
        return new GovernanceRoleDefinitionRequest(contextPath.addSegment("roleDefinition"), Optional.empty());
    }

    public GovernanceSubjectRequest subject() {
        return new GovernanceSubjectRequest(contextPath.addSegment("subject"), Optional.empty());
    }

}
