package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Financials;
import odata.msgraph.client.beta.entity.collection.request.CompanyCollectionRequest;

@JsonIgnoreType
public class FinancialsRequest extends EntityRequest<Financials> {

    public FinancialsRequest(ContextPath contextPath, Optional<Object> value) {
        super(Financials.class, contextPath, value, false);
    }

    public CompanyRequest companies(String id) {
        return new CompanyRequest(contextPath.addSegment("companies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CompanyCollectionRequest companies() {
        return new CompanyCollectionRequest(
                        contextPath.addSegment("companies"), Optional.empty());
    }

}
