package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ExactMatchSession;

@JsonIgnoreType
public class ExactMatchSessionRequest extends EntityRequest<ExactMatchSession> {

    public ExactMatchSessionRequest(ContextPath contextPath, Optional<Object> value) {
        super(ExactMatchSession.class, contextPath, value, false);
    }

    public ExactMatchUploadAgentRequest uploadAgent() {
        return new ExactMatchUploadAgentRequest(contextPath.addSegment("uploadAgent"), Optional.empty());
    }

    @Action(name = "cancel")
    @JsonIgnore
    public ActionRequestNoReturn cancel() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancel"), _parameters);
    }

    @Action(name = "renew")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ExactMatchSession> renew() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<ExactMatchSession>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.renew"), ExactMatchSession.class, _parameters);
    }

    @Action(name = "commit")
    @JsonIgnore
    public ActionRequestNoReturn commit() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.commit"), _parameters);
    }

}
