package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ExactMatchLookupJob;
import odata.msgraph.client.beta.entity.collection.request.LookupResultRowCollectionRequest;

@JsonIgnoreType
public class ExactMatchLookupJobRequest extends EntityRequest<ExactMatchLookupJob> {

    public ExactMatchLookupJobRequest(ContextPath contextPath, Optional<Object> value) {
        super(ExactMatchLookupJob.class, contextPath, value, false);
    }

    public LookupResultRowRequest matchingRows(String id) {
        return new LookupResultRowRequest(contextPath.addSegment("matchingRows").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public LookupResultRowCollectionRequest matchingRows() {
        return new LookupResultRowCollectionRequest(
                        contextPath.addSegment("matchingRows"), Optional.empty());
    }

}
