package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.EntitlementManagement;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentResourceRoleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageCatalogCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceEnvironmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceRoleScopeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ApprovalCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConnectedOrganizationCollectionRequest;

@JsonIgnoreType
public class EntitlementManagementRequest extends EntityRequest<EntitlementManagement> {

    public EntitlementManagementRequest(ContextPath contextPath, Optional<Object> value) {
        super(EntitlementManagement.class, contextPath, value, false);
    }

    public ApprovalRequest accessPackageAssignmentApprovals(String id) {
        return new ApprovalRequest(contextPath.addSegment("accessPackageAssignmentApprovals").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ApprovalCollectionRequest accessPackageAssignmentApprovals() {
        return new ApprovalCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentApprovals"), Optional.empty());
    }

    public AccessPackageAssignmentPolicyRequest accessPackageAssignmentPolicies(String id) {
        return new AccessPackageAssignmentPolicyRequest(contextPath.addSegment("accessPackageAssignmentPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageAssignmentPolicyCollectionRequest accessPackageAssignmentPolicies() {
        return new AccessPackageAssignmentPolicyCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentPolicies"), Optional.empty());
    }

    public AccessPackageAssignmentRequestRequest accessPackageAssignmentRequests(String id) {
        return new AccessPackageAssignmentRequestRequest(contextPath.addSegment("accessPackageAssignmentRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageAssignmentRequestCollectionRequest accessPackageAssignmentRequests() {
        return new AccessPackageAssignmentRequestCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentRequests"), Optional.empty());
    }

    public AccessPackageAssignmentResourceRoleRequest accessPackageAssignmentResourceRoles(String id) {
        return new AccessPackageAssignmentResourceRoleRequest(contextPath.addSegment("accessPackageAssignmentResourceRoles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageAssignmentResourceRoleCollectionRequest accessPackageAssignmentResourceRoles() {
        return new AccessPackageAssignmentResourceRoleCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentResourceRoles"), Optional.empty());
    }

    public AccessPackageAssignmentRequest accessPackageAssignments(String id) {
        return new AccessPackageAssignmentRequest(contextPath.addSegment("accessPackageAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageAssignmentCollectionRequest accessPackageAssignments() {
        return new AccessPackageAssignmentCollectionRequest(
                        contextPath.addSegment("accessPackageAssignments"), Optional.empty());
    }

    public AccessPackageCatalogRequest accessPackageCatalogs(String id) {
        return new AccessPackageCatalogRequest(contextPath.addSegment("accessPackageCatalogs").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageCatalogCollectionRequest accessPackageCatalogs() {
        return new AccessPackageCatalogCollectionRequest(
                        contextPath.addSegment("accessPackageCatalogs"), Optional.empty());
    }

    public AccessPackageResourceEnvironmentRequest accessPackageResourceEnvironments(String id) {
        return new AccessPackageResourceEnvironmentRequest(contextPath.addSegment("accessPackageResourceEnvironments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageResourceEnvironmentCollectionRequest accessPackageResourceEnvironments() {
        return new AccessPackageResourceEnvironmentCollectionRequest(
                        contextPath.addSegment("accessPackageResourceEnvironments"), Optional.empty());
    }

    public AccessPackageResourceRequestRequest accessPackageResourceRequests(String id) {
        return new AccessPackageResourceRequestRequest(contextPath.addSegment("accessPackageResourceRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageResourceRequestCollectionRequest accessPackageResourceRequests() {
        return new AccessPackageResourceRequestCollectionRequest(
                        contextPath.addSegment("accessPackageResourceRequests"), Optional.empty());
    }

    public AccessPackageResourceRoleScopeRequest accessPackageResourceRoleScopes(String id) {
        return new AccessPackageResourceRoleScopeRequest(contextPath.addSegment("accessPackageResourceRoleScopes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageResourceRoleScopeCollectionRequest accessPackageResourceRoleScopes() {
        return new AccessPackageResourceRoleScopeCollectionRequest(
                        contextPath.addSegment("accessPackageResourceRoleScopes"), Optional.empty());
    }

    public AccessPackageResourceRequest accessPackageResources(String id) {
        return new AccessPackageResourceRequest(contextPath.addSegment("accessPackageResources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageResourceCollectionRequest accessPackageResources() {
        return new AccessPackageResourceCollectionRequest(
                        contextPath.addSegment("accessPackageResources"), Optional.empty());
    }

    public AccessPackageRequest accessPackages(String id) {
        return new AccessPackageRequest(contextPath.addSegment("accessPackages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessPackageCollectionRequest accessPackages() {
        return new AccessPackageCollectionRequest(
                        contextPath.addSegment("accessPackages"), Optional.empty());
    }

    public ConnectedOrganizationRequest connectedOrganizations(String id) {
        return new ConnectedOrganizationRequest(contextPath.addSegment("connectedOrganizations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConnectedOrganizationCollectionRequest connectedOrganizations() {
        return new ConnectedOrganizationCollectionRequest(
                        contextPath.addSegment("connectedOrganizations"), Optional.empty());
    }

    public EntitlementManagementSettingsRequest settings() {
        return new EntitlementManagementSettingsRequest(contextPath.addSegment("settings"), Optional.empty());
    }

}
