package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.EnrollmentProfile;

@JsonIgnoreType
public class EnrollmentProfileRequest extends EntityRequest<EnrollmentProfile> {

    public EnrollmentProfileRequest(ContextPath contextPath, Optional<Object> value) {
        super(EnrollmentProfile.class, contextPath, value, false);
    }

    @Action(name = "setDefaultProfile")
    @JsonIgnore
    public ActionRequestNoReturn setDefaultProfile() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setDefaultProfile"), _parameters);
    }

    @Action(name = "updateDeviceProfileAssignment")
    @JsonIgnore
    public ActionRequestNoReturn updateDeviceProfileAssignment(List<String> deviceIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceIds", "Collection(Edm.String)", Checks.checkIsAscii(deviceIds))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateDeviceProfileAssignment"), _parameters);
    }

    @Function(name = "exportMobileConfig")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> exportMobileConfig() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.exportMobileConfig"), String.class, _parameters);
    }

}
