package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.EmbeddedSIMActivationCodePool;
import odata.msgraph.client.beta.entity.EmbeddedSIMActivationCodePoolAssignment;
import odata.msgraph.client.beta.entity.collection.request.EmbeddedSIMActivationCodePoolAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EmbeddedSIMDeviceStateCollectionRequest;

@JsonIgnoreType
public class EmbeddedSIMActivationCodePoolRequest extends EntityRequest<EmbeddedSIMActivationCodePool> {

    public EmbeddedSIMActivationCodePoolRequest(ContextPath contextPath, Optional<Object> value) {
        super(EmbeddedSIMActivationCodePool.class, contextPath, value, false);
    }

    public EmbeddedSIMActivationCodePoolAssignmentRequest assignments(String id) {
        return new EmbeddedSIMActivationCodePoolAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EmbeddedSIMActivationCodePoolAssignmentCollectionRequest assignments() {
        return new EmbeddedSIMActivationCodePoolAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    public EmbeddedSIMDeviceStateRequest deviceStates(String id) {
        return new EmbeddedSIMDeviceStateRequest(contextPath.addSegment("deviceStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EmbeddedSIMDeviceStateCollectionRequest deviceStates() {
        return new EmbeddedSIMDeviceStateCollectionRequest(
                        contextPath.addSegment("deviceStates"), Optional.empty());
    }

    @Action(name = "assign")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmbeddedSIMActivationCodePoolAssignment> assign(List<EmbeddedSIMActivationCodePoolAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.embeddedSIMActivationCodePoolAssignment)", assignments)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), EmbeddedSIMActivationCodePoolAssignment.class, _parameters);
    }

}
